/*
Copyright 2008-2011 Broadcom Corporation

This program isthe proprietary software of Broadcom Corporation and/or its
licensors, and may only be used, duplicated, modifiedor distributed pursuant to
the terms and conditions of a separate, written license agreement executed
between you and Broadcom (an "Authorized License"). Except as set forth in an
Authorized License, Broadcom grants no license (express or implied), right to
use, or waiver of any kind with respect to the Software, and Broadcom expressly
reserves all rights in and to the Software and all intellectual property rights
therein. IF YOU HAVE NO AUTHORIZED LICENSE, THEN YOU HAVE NO RIGHT TO USE THIS
SOFTWARE IN ANY WAY, AND SHOULD IMMEDIATELY NOTIFY BROADCOM AND DISCONTINUE ALL
USE OF THE SOFTWARE.

Except as expressly set forth in the Authorized License,

1. This program, including its structure, sequence and organization, constitutes
   the valuable trade secrets of Broadcom, and you shall use all reasonable
   efforts to protect the confidentiality thereof, and to use this information
   only in connection with your use of Broadcom integrated circuit products.

2.TO THE MAXIMUM EXTENT PERMITTED BY LAW, THE SOFTWAREIS PROVIDED "AS IS" AND
   WITH ALL FAULTS AND BROADCOM MAKES NO PROMISES, REPRESENTATIONS OR
   WARRANTIES, EITHER EXPRESS, IMPLIED, STATUTORY, OR OTHERWISE, WITH RESPECT TO
   THE SOFTWARE.  BROADCOM SPECIFICALLY DISCLAIMSANY AND ALL IMPLIED WARRANTIES
   OF TITLE, MERCHANTABILITY, NONINFRINGEMENT, FITNESS FOR A PARTICULAR PURPOSE,
   LACK OF VIRUSES, ACCURACY OR COMPLETENESS, QUIET ENJOYMENT, QUIET POSSESSION
   OR CORRESPONDENCE TO DESCRIPTION. YOU ASSUME THE ENTIRE RISK ARISING OUT OF
   USE OR PERFORMANCE OF THE SOFTWARE.

3.TO THE MAXIMUM EXTENT PERMITTED BY LAW, IN NO EVENT SHALL BROADCOM OR ITS
   LICENSORS BE LIABLE FOR(i) CONSEQUENTIAL, INCIDENTAL, SPECIAL, INDIRECT, OR
   EXEMPLARY DAMAGES WHATSOEVER ARISING OUT OF OR IN ANY WAY RELATING TO YOUR
   USE OF OR INABILITY TO USE THE SOFTWARE EVEN IF BROADCOM HAS BEEN ADVISED OF
   THE POSSIBILITY OF SUCH DAMAGES; OR (ii) ANY AMOUNT IN EXCESS OF THE AMOUNT
   ACTUALLY PAID FOR THE SOFTWARE ITSELF OR U.S. $1, WHICHEVER IS GREATER. THESE
   LIMITATIONS SHALL APPLY NOTWITHSTANDING ANY FAILURE OF ESSENTIAL PURPOSE OF
   ANY LIMITED REMEDY.
*/
/** \file l2layer.h
 *
 * \brief This are the definitions for the L2 layer
 *
 **************************************************/

#ifndef L2LAYER_H_
#define L2LAYER_H_

/***************************************************
*                 Include section
***************************************************/
#include "framework.h"
#include "transactions/definitions.h"

/***************************************************
 *                 Public Defines Section
 ***************************************************/

/***************************************************
 *                 Public Constants Section
 ***************************************************/

 /***************************************************
 *                 Public Typedefs Section
 ***************************************************/

 /***************************************************
 *         Public Function Prototypes Section
 ***************************************************/

/**
 * \brief            Initializes L2 layer
 */
void l2layer_init();

/**
 * \brief            L2 layer transmission function
 *
 * \param p_layer    (in) protocol layer
 * \param p_pkt      (in) protocol packet to transmit
 */
void l2layer_Transmit(tS_layer* p_layer, tS_pkt* p_pkt);

/**
 * \brief            L2 layer reception function
 *
 * \param p_layer    (in) protocol layer
 * \param p_pkt      (in) protocol packet received
 */
void l2layer_Handle_Receive(tS_layer* p_layer, tS_pkt* p_pkt);

/**
 * \brief               Retrieve data received from the STA
 *
 * \param   p_data      (out) point to a buffer which will hold the data from
 *                            the protocol packet received
 * \param   p_size      (out) 'p_data' size
 * \param   p_mmtype    (out) mmtype for the packet received
 *
 * \return  TBool       FALSE if there isn't data available, otherwise is TRUE
 */
TBool l2layer_GetResponse(TU8* p_data, int* p_size, TU16* p_mmtype);

/**
 * \brief               Fill a tS_APL2C_ERROR_CNF struct with the information
 *                      contained in 'response'
 *
 * \param p_err_cnf     (out) tS_APL2C_ERROR_CNF struct
 * \param p_response    (in)  stream of bytes with the info to copy in 'err_cnf'
 */
void l2layer_SetErrorCNFStruct(tS_APL2C_ERROR_CNF* p_err_cnf,TU8* p_response);

/**
 * \brief Register a callback function for *.IND pkts that send to clients an
 *        array of bytes
 *
 *    This method is called from the client to register a callback that it will
 *    be called when a *.IND pkt will be received from the STA.
 *
 *   \param callback  function pointer
 */
void l2layer_Subscribe(void (*callback)(TU8*,TU16), TU16 mmtype);

/**
 * \brief Unregister a callback function previously registered.
 *
 * \param callback  function pointer
 */
void l2layer_Unsubscribe(void (*callback)(TU8*, TU16));

/**
 * \brief Register a callback function for *.IND pkts that send to clients an
 *        array of bytes
 *
 *    This method is called from the client to register a callback that it will
 *    be called when a *.IND pkt will be received from the STA.
 *
 *   \param callback  function pointer
 */
void l2layer_SubscribeRich(void (*callback)(TU8*, TU16,TU8*), TU16 mmtype);

/**
 * \brief Unregister a callback function previously registered.
 *
 * \param callback  function pointer
 */
void l2layer_UnsubscribeRich(void (*callback)(TU8*, TU16,TU8*));

#endif
